﻿using System.Collections;
using System.Collections.Generic;
using TMPro;
using UnityEngine;
using UnityEngine.EventSystems;
using UnityEngine.UI;

public class ReadyMenu : MonoBehaviour
{
    private GameObject _BackgroundPanel;
    private bool _IsBegin;

    public void Awake()
    {
        //Subscribe to events
        InputManager.Instance.InputStateChanged += OnInputStateChanged;
        _BackgroundPanel = gameObject.FindChild("BackgroundPanel");
        _BackgroundPanel.GetComponent<PhaseAnimation>().BounceInCompleted += ReadyMenu_BounceInCompleted;
        _BackgroundPanel.GetComponent<PhaseAnimation>().BounceOutCompleted += ReadyMenu_BounceOutCompleted;
    }

    private void ReadyMenu_BounceInCompleted(object sender, System.EventArgs e)
    {
        if (InputManager.Instance.InputState == Constants.InputState.Controller)
        {
            //We've just changed to a controller so focus on the ready button
            EventSystem.current.SetSelectedGameObject(null);
            EventSystem.current.SetSelectedGameObject(_BackgroundPanel.FindChild("ReadyButton"));
        }

        //Bouncing is done so enable the UI
        gameObject.Enable();
    }

    private void ReadyMenu_BounceOutCompleted(object sender, System.EventArgs e)
    {
        //Bouncing is done so hide the ready UI, reset the time scale and change to the appropriate phase
        GameController.Instance.ReadyScreen.SetActive(false);
        Time.timeScale = 1.0f;

        if (_IsBegin)
        {
            //The ready memu is being shown during the begin phase so it's time to hide
            GameController.Instance.ChangeGamePhase(new HidingPhase());
        }

        else
        {
            //The ready memu is being shown during the intermission phase so it's time to seek
            GameController.Instance.ChangeGamePhase(new SeekingPhase());
        }
    }

    private void OnInputStateChanged(object sender, InputManager.InputStateChangedEventArgs e)
    {
        if (e.NewState == Constants.InputState.Controller && gameObject.activeSelf)
        {
            //We've just changed to a controller so focus on the ready button
            EventSystem.current.SetSelectedGameObject(null);
            EventSystem.current.SetSelectedGameObject(_BackgroundPanel.FindChild("ReadyButton"));
            e.Handled = true;
        }
    }

    private void OnDestroy()
    {
        //Unsubscribe from events
        InputManager.Instance.InputStateChanged -= OnInputStateChanged;
        _BackgroundPanel.GetComponent<PhaseAnimation>().BounceInCompleted -= ReadyMenu_BounceInCompleted;
        _BackgroundPanel.GetComponent<PhaseAnimation>().BounceOutCompleted -= ReadyMenu_BounceOutCompleted;
    }

    public void MoveToThis(bool begin)
    {
        //We're moving to the ready menu, so set the IsBegin variable and disable the UI
        _IsBegin = begin;
        gameObject.Disable();

        if (_IsBegin)
        {
            //This is the begin stage, so set the appropriate images and text
            _BackgroundPanel.FindChild("First").FindChild("BackgroundCircle").FindChild("CharacterImage").GetComponent<Image>().sprite = GameController.Instance.HiderPlayerObject.GetComponent<SpriteRenderer>().sprite;
            _BackgroundPanel.FindChild("First").FindChild("Text").GetComponent<TMP_Text>().SetText("GO HIDE!");

            _BackgroundPanel.FindChild("Second").FindChild("BackgroundCircle").FindChild("CharacterImage").GetComponent<Image>().sprite = GameController.Instance.SeekerPlayerObject.GetComponent<SpriteRenderer>().sprite;
            _BackgroundPanel.FindChild("Second").FindChild("Text").GetComponent<TMP_Text>().SetText("TURN AWAY!");
        }

        else
        {
            //This is the intermission stage, so set the appropriate images and text
            _BackgroundPanel.FindChild("First").FindChild("BackgroundCircle").FindChild("CharacterImage").GetComponent<Image>().sprite = GameController.Instance.SeekerPlayerObject.GetComponent<SpriteRenderer>().sprite;
            _BackgroundPanel.FindChild("First").FindChild("Text").GetComponent<TMP_Text>().SetText("GO SEEK!");

            _BackgroundPanel.FindChild("Second").FindChild("BackgroundCircle").FindChild("CharacterImage").GetComponent<Image>().sprite = GameController.Instance.HiderPlayerObject.GetComponent<SpriteRenderer>().sprite;
            _BackgroundPanel.FindChild("Second").FindChild("Text").GetComponent<TMP_Text>().SetText("HELP THE SEEKER?");
        }

        //Begin animating the panel in
        _BackgroundPanel.gameObject.transform.localScale = new Vector3(0.0f, 0.0f, 1.0f);
        _BackgroundPanel.GetComponent<Animator>().Play("BounceIn", -1, 0.0f);
    }

    public void MoveToNext()
    {
        //We're moving away so disable the UI and begin animating the panel
        gameObject.Disable();
        _BackgroundPanel.GetComponent<Animator>().Play("BounceOut", -1, 0.0f);
    }
}